;;; Ystok-Media - Media player by means of ActiveX (OLE) on LispWorks for Windows
;;; Copyright (c) 2025 Dr. Dmitry Ivanov. All rights reserved.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Package definition

(in-package :cl-user)

;(eval-when (:compile-toplevel :load-toplevel :execute)
;  (require "embed"))

(defpackage :ystok.media
 (:nicknames :med)
 (:use :common-lisp) ;#+ys-product :ystok.library
 (:import-from :lispworks
  lw:appendf lw:nconcf lw:push-end lw:removef lw:string-append lw:when-let lw:when-let*)

 (:export
  #:*audio-file-types*
  #:*autoloop*
  #:*autostart*
  #:*ui-mode*
  #:*current-vendor-id*
  #:*singleton*
  #:*photo-duration*
  #:*photo-file-types*		; static pictures
  #:*ui-mode-alist*
  #:*vendors*
  #:*video-file-types*

  #:find-vendor			; id => vendor instance
  #:index
  #:item			; structure class
  #:media-file-filters

  #:on-end			; Callbacks
  #:on-open
  #:on-pause
  #:on-play
  #:on-state-change		; time, status or position
  #:on-stop

  #:player			; class name and accessor
  #:player-pane			; capi:ole-control-pane subclass
  #:state
  #:status
  #:set-pane-vendor		; helper for switch implementations
  #:timestring			; helper printing time or duration in "[hH:]MM:SS" format

  #:vendor			; structure class name
  #:vendor-add
  #:vendor-clear
  #:vendor-component-name
  #:vendor-component-on-close
  #:vendor-component-on-insert
  #:vendor-duration #:vendor-duration-string
  #:vendor-fast-backward #:vendor-fast-forward
  #:vendor-get
  #:vendor-id
  #:vendor-item-descripton
  #:vendor-items-count
  #:vendor-next
  #:vendor-position
  #:vendor-play
  #:vendor-previous
  #:vendor-remove
  #:vendor-status
  #:vendor-stop
  #:vendor-time #:vendor-timestring
  #:vendor-title
  #:vendor-pause
  #:vendor-ui-mode
  #:vendor-version

  ;; Vendor-dependent implementatioln classes
  ;#:flash-plaer
  ;#:vlc-player
  ;#:wm-plaer
))
