;;; Ystok-Media - Media player by means of ActiveX (OLE pane) on LispWorks for Windows
;;; Copyright (c) 2025 Dr. Dmitry Ivanov. All rights reserved.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Macromedia/Adobe Flash Player support
;;; Based on examples/com/ole/flash-player.lisp

(in-package :ystok.media)

(define-vendor :flash
               :title "Flash Player"
               :component-name "ShockwaveFlash.ShockwaveFlash.1"
               :player-class 'flash-player)

(defclass flash-player (player)
 ((vendor-id :allocation :class :initform :flash)))

(defmethod vendor-add ((player flash-player) pane &key pathname (clear t))
  (declare (ignore clear))
  (let ((url (string-append "file:///" (namestring pathname)))
        (item (make-instance 'item :url pathname :title (pathname-name pathname))))
    (when clear
      (vendor-clear player pane))
    (push-end item (items player))
    (setf (index player) 0)
    (com:invoke-dispatch-put-property (i-dispatch pane player) "Movie" url)))

(defmethod vendor-play ((player flash-player) pane &key index item)
  (declare (ignore index item))
  (com:invoke-dispatch-method (i-dispatch pane player) "Play"))

(defmethod vendor-pause ((player flash-player) pane &key on)
  (if on
      (com:invoke-dispatch-method (i-dispatch pane player) "Stop")
      (vendor-play player pane)))

(defmethod vendor-rewind ((player flash-player) pane)
  (com:invoke-dispatch-method (i-dispatch pane player) "Rewind"))

(defmethod vendor-stop ((player flash-player) pane  &key silent)
  (declare (ignore silent)))

#|
(defmethod vendor-next ((player flash-player) pane)
  (let* ((items (items player))
         ;(len (length items))
         (old (index player))
         (new (cond ((< old 0) nil)				; no current item
                    ((< (1+ old) (length items)) (1+ old))	; not last in the list
                    ((vendor-get player pane :autoloop *autoloop*) ; if last in the list,
                     0))))					;  loop to the first
    (cond ((and new (if (= new old) force t))			; force replaying the same
           (vendor-assign-current-item player pane new))	; <= item
          ((not force)
           (capi:beep-pane pane)))))

(defmethod vendor-previous ((player wm-player) pane)
 (let* ((items (items player))
         ;(len (length items))
         (old (index player))
         (new (cond ((< old 0) nil)				; no current item
                    ((< 0 old) (1- old))			; not first in the list
                    ((vendor-get player pane :autoloop *autoloop*) ; if first in the list,
                     (1- (length items))))))			 ; loop to the last
    (if (and new (/= new old)
             ;(progn (vendor-stop player pane)
             (vendor-assign-current-item player pane new))
        t
        (capi:beep-pane pane))))
|#
