;;; Ystok-Media - Media player by means of ActiveX (OLE pane) on LispWorks for Windows
;;; Copyright (c) 2025 Dr. Dmitry Ivanov. All rights reserved.
;;; $Id: defsys.lisp 15 2021-11-19 16:49:48Z gigo $
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; LispWorks system definition

(in-package :cl-user)

;(pushnew :ys-product *features*)
;(pushnew :debug *features*)

(require "embed")

;; Recover from unneeded overriding binding to "Save Region Preserving Selection"
(editor:bind-key "Save Region Preserving Selection" "Control-c")
#+Russian (editor:bind-key "Save Region Preserving Selection" "Control-")

#+debug (toggle-source-debugging t)

#+ys-product (load #P"PROJECTS:ffc;defsys")
#+(and ys-product (not deliver)) (lw:compile-system 'YSTOK-FFC :load t)
#+(and ys-product deliver) (load-system 'YSTOK-FFC)

#+ys-product (load #P"PROJECTS:ylib;src;defsys")
#+(and ys-product (not deliver)) (lw:compile-system 'YSTOK-LIBRARY :load t)
#+(and ys-product deliver) (load-system 'YSTOK-LIBRARY)

#+ys-product (load #P"PROJECTS:widgets;src;defsys")
#+(and ys-product (not deliver)) (compile-system 'YWIDGETS :load t)
#+(and ys-product deliver) (load-system 'YWIDGETS)

(defsystem YSTOK-MEDIA (#+ys-product #+ys-product
                        :object-pathname (features-folder "FASL:media;"
                                                          :debug ;:ys-product
                                                          '(:Russian . "ru")))
 :members
 (#+ys-product (YSTOK-FFC	:type :system)
  #+ys-product (YSTOK-LIBRARY	:type :system)
  #+ys-product (YWIDGETS	:type :system)
  "package"
  "basics"
  "vlc"
  "wmp"
  "flash"
  "test-interface")
 :rules
 ((:in-order-to :compile :all (:requires (:load :previous)))
  (:in-order-to :load :all (:requires (:load :previous)))))

#+ys-product 
(ys:defmodule :media (1 0) :abbrev "med" :required :commit) ;:depends-on :ylib)

#||
(compile-system 'YSTOK-MEDIA :load t)

(removef *features* :debug)
||#
