;;; Ystok-Media - Media player by means of ActiveX (OLE pane) on LispWorks for Windows
;;; Copyright (c) 2025 Dr. Dmitry Ivanov. All rights reserved.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Application Builder script (requires Ystok-Library and other subsystems!)
;;; Usage:
;;; - Select this file as "Build script",
;;; - Select menu Build -> Build.

(in-package :cl-user)

(load-logical-pathname-translations "PROJECTS")

(toggle-source-debugging nil)
(setq lw:*load-source-if-newer* nil)		; do not compile in here
(pushnew :ys-product *features*)
(pushnew :debug *features*)
(pushnew :deliver *features*)

(load (current-pathname "../src/defsys"))

;(progn (format *query-io* "~&After defsys:") (read-line *query-io*))

(compile-file-if-needed ;"PROJECTS:fli-templates.lisp"
	(current-pathname "fli-templates.lisp")
	:output-file (current-pathname #-debug "fli-templates"
                                       #+debug "fli-templates-debug"
                                       sys:*binary-file-type*)
	:load t)

(load-system 'YSTOK-MEDIA)		

#+debug (yl:define-debug-option :media :all "Media player dubugging")

(setq yl:*thys-product-name* "Ystok Media Player")

(scm:clear-systems-from-image)				; -900K!
(clrhash SYSTEM::*LOGICAL-PATHNAME-TRANSLATIONS*)
(removef *features* :deliver)

(deliver 'cl-user::main (current-pathname "yplayer.exe")
  5
  :console #+debug :always #-debug :input
  :display-progress-bar nil
  :icon-file (current-pathname "yplayer.ico")
  :interface :capi
  :keep-clos t
  :keep-clos-object-printing t
  :keep-conditions :all
  ;:keep-debug-mode t
  :keep-eval nil
  :keep-lisp-reader nil
  :keep-load-function nil
  ;:packages-to-keep '(:ystok.media :cl-user)
  :packages-to-keep-symbol-names '(:ystok.media)
  :quit-when-no-windows t
  :startup-bitmap-file nil
  :structure-packages-to-keep '(:ystok.media)
  :symbol-names-action :spell-error
  :symbols-to-keep-structure-info '(restart pathname system::unc-pathname))
  :versioninfo `(:binary-version ,(+ (ash 1 48) (ash 0 32) 1)
                 :version-string "1.0.001" ;,ys:*thys-version-string*
                 ;:language :US-English
                 :company-name "Ystok-Systema"
                 :legal-copyright " 2025 Ystok-Systema"
                 :product-name ,yl:*thys-product-name*
                 :file-description "Ystok-Media library test application."))
  :warn-on-missing-templates t			; method combination templates
)

#||
;;; GATHERING FLI TEMPLATES

(fli:start-collecting-template-info)
(main)
;(fli:print-collected-template-info) ;:keep t)
(with-open-file (stream (current-pathname "fli-temp.lisp") :direction :output)
  (fli:print-collected-template-info :output-stream stream))
||#
